# Cuadro XI.1
# Regresin lineal simple

########################################################
# Seccin modificable por el usuario
########################################################
datos<-read.csv2("Cuadro XI.1.V.csv",enc="latin1")

#Variable dependiente
varRespuesta<-"Peso.gr"

#Variable independiente
varExplicativa<-"Ancho.cm"

# Modelos posibles:
# 1. Lineal 
# 2. Logartmico
# 3. Potencial
# 4. Exponencial
# 5. Curva-S
# 6. Cuadrtica o Parbola
# 7. Inversa

Selecmodelos<-c(1,2,3,4,5,6,7)
#Selecmodelos<-c(1,3,4)

#Variables de seleccin.
varSeleccion1<-list(c("Especie","Molusco 1"))
#varSeleccion1<-NULL
#varSeleccion2<-list(c("Especie","Molusco 2","Molusco 3"))
varSeleccion2<-NULL

#Nombre del archivo de salida
ArchivodeSalida<-"Salida Cuadro XI.1.txt"

#Nombre del archivo en que se guardan los residuos
CSV<-"Salida Cuadro XI.1.csv"

########################################################
# Seccin que realiza el procedimiento
########################################################

#paquetes
require(nortest)
require(car)
require(lmtest)

#Selecciones
if (length(varSeleccion1)!=0){
 w1<-data.frame(row.names=1:dim(datos)[1])
 varBin1<-as.character()
 for (i in 1:length(varSeleccion1)){
   nom1<-varSeleccion1[[i]][1]
   x1<-factor(datos[,nom1])
   if (length(varSeleccion1[[i]])>1){
      sufijo1<-paste(varSeleccion1[[i]][2:3],collapse="_")
      nom1<-paste(nom1,".",sufijo1,sep="")
      x11<-factor(ifelse(x1 %in% varSeleccion1[[i]][2:3],as.character(x1),NA))
      x11<-data.frame(factor(x11))
   }else{
      x11<-x1
      x11<-data.frame(x1)
   }
   names(x11)<-nom1
   varBin1<-c(varBin1,nom1)
   w1<-data.frame(w1,x11)
 }
}

if (length(varSeleccion2)!=0){
 w2<-data.frame(row.names=1:dim(datos)[1])
 varBin2<-as.character()
 for (i in 1:length(varSeleccion2)){
   nom2<-varSeleccion2[[i]][1]
   x2<-factor(datos[,nom2])
   if (length(varSeleccion2[[i]])>1){
      sufijo2<-paste(varSeleccion2[[i]][2:3],collapse="_")
      nom2<-paste(nom2,".",sufijo2,sep="")
      x12<-factor(ifelse(x2 %in% varSeleccion2[[i]][2:3],as.character(x2),NA))
      x12<-data.frame(factor(x12))
   }else{
      x12<-x2
      x12<-data.frame(x2)
   }
   names(x12)<-nom2
   varBin2<-c(varBin2,nom2)
   w2<-data.frame(w2,x12)
 }
}

if ((length(varSeleccion1)!=0)&(length(varSeleccion2)!=0)) seleccion<-data.frame(w1,w2)
if ((length(varSeleccion1)!=0)&(length(varSeleccion2)==0)) seleccion<-data.frame(w1)
if ((length(varSeleccion1)==0)&(length(varSeleccion2)!=0)) seleccion<-data.frame(w2)
if ((length(varSeleccion1)==0)&(length(varSeleccion2)==0)) seleccion<-NULL

#Conjunto de datos
if (length(seleccion)==0) datos2<-data.frame(datos)
if (length(seleccion)!=0) datos2<-data.frame(seleccion,datos)
datos<-na.omit(datos2)

#Lista de frmulas posibles
listaFormulas<-NULL

for (i in Selecmodelos){
  if (i==1) listaFormulas<-c(listaFormulas,paste(varRespuesta,"~",varExplicativa,sep=""))
  if (i==2) listaFormulas<-c(listaFormulas,paste(varRespuesta,"~","log(",varExplicativa,")",sep=""))
  if (i==3) listaFormulas<-c(listaFormulas,paste("log(",varRespuesta,")","~","log(",varExplicativa,")",sep=""))
  if (i==4) listaFormulas<-c(listaFormulas,paste("log(",varRespuesta,")","~",varExplicativa,sep=""))
  if (i==5) listaFormulas<-c(listaFormulas,paste("log(",varRespuesta,")","~","I(1/",varExplicativa,")",sep=""))
  if (i==6) listaFormulas<-c(listaFormulas,paste(varRespuesta,"~",varExplicativa,"+I(",varExplicativa,"^2)",sep=""))
  if (i==7) listaFormulas<-c(listaFormulas,paste(varRespuesta,"~","I(1/",varExplicativa,")",sep=""))
}

#Funciones necesarias

estimaModelos<-function(formula,datos){
 modelo<-lm(formula,data=datos)
 return(list(formula=formula,modelo=modelo))
}

imprimeModelo<-function(x){
 cat("----------------------------------\n")
 cat("Modelo:",x$formula,"\n")
 cat("Tabla ANOVA \n")
 print(anova(x$modelo))
 cat("Estimacin de parmetros \n")
 print(summary(x$modelo))
 cat("----------------------------------\n")
 return(invisible(NULL))
}

graficasDisp<-function(formula1,datos){
  f1<-as.formula(formula1)
  x11()
  plot(f1,data=datos)
  legend("top",legend=formula1)
}

extraeResiduos<-function(formula,datos){
  modelo<-lm(formula,data=datos)
  residuos<-residuals(modelo)
  return(residuos=residuos)
}

BP<-function(formula,datos){
  modelo<-lm(formula,data=datos)
  BPtest<-bptest(modelo)
  return(BPtest)
}

estimaDW<-function(formula,datos){
 modelo<-lm(formula,data=datos)
 DW<-durbin.watson(modelo)
 return(DW)
}

#Aplicando funciones a los datos

modelos<-lapply(listaFormulas,estimaModelos,datos)

listaFormulas<-as.list(listaFormulas)
names(listaFormulas)<-Selecmodelos

for (i in Selecmodelos){
 if(i==1)graficasDisp(listaFormulas$'1',datos)
 if(i==2)graficasDisp(listaFormulas$'2',datos)
 if(i==3)graficasDisp(listaFormulas$'3',datos)
 if(i==4)graficasDisp(listaFormulas$'4',datos)
 if(i==5)graficasDisp(listaFormulas$'5',datos)
 if(i==6)graficasDisp(listaFormulas$'6',datos)
 if(i==7)graficasDisp(listaFormulas$'7',datos)
}

residuos<-lapply(listaFormulas,extraeResiduos,datos)
names(residuos)<-Selecmodelos

#Test de normalidad
for (i in Selecmodelos){
 if(i==1) Shapiro1<-shapiro.test(residuos$'1')
          Lillie1<-lillie.test(residuos$'1')
 if(i==2) Shapiro2<-shapiro.test(residuos$'2')
          Lillie2<-lillie.test(residuos$'2')
 if(i==3) Shapiro3<-shapiro.test(residuos$'3')
          Lillie3<-lillie.test(residuos$'3')
 if(i==4) Shapiro4<-shapiro.test(residuos$'4')
          Lillie4<-lillie.test(residuos$'4')
 if(i==5) Shapiro5<-shapiro.test(residuos$'5')
          Lillie5<-lillie.test(residuos$'5')
 if(i==6) Shapiro6<-shapiro.test(residuos$'6')
          Lillie6<-lillie.test(residuos$'6')
 if(i==7) Shapiro7<-shapiro.test(residuos$'7')
          Lillie7<-lillie.test(residuos$'7')
}

#Test de Homocedasticidad de los residuos de Breusch-Pagan
BreuschPagan<-lapply(listaFormulas,BP,datos)

#Test de Durbin-Watson de autocorrelacin de errores
DW<-lapply(listaFormulas,estimaDW,datos)

########################################################
# Seccin que muestra los resultados
########################################################

#Genera archivo csv con resduos
for (i in Selecmodelos){
 if(i==1) Res<-data.frame(residuos$'1')
 if(i==2) Res<-data.frame(Res,residuos$'2')
 if(i==3) Res<-data.frame(Res,residuos$'3')
 if(i==4) Res<-data.frame(Res,residuos$'4')
 if(i==5) Res<-data.frame(Res,residuos$'5')
 if(i==6) Res<-data.frame(Res,residuos$'6')
 if(i==7) Res<-data.frame(Res,residuos$'7')
 }

Residuos<-data.frame(datos[,varRespuesta],Res)

write.csv2(Residuos,file=CSV)

#Imprime resultados en archivo txt
if(!is.null(ArchivodeSalida)){
 sink(ArchivodeSalida)
 print(lapply(modelos,imprimeModelo))
 for (i in Selecmodelos){
   if(i==1) print(list(Shapiro1,Lillie1))
   if(i==2) print(list(Shapiro2,Lillie2))
   if(i==3) print(list(Shapiro3,Lillie3))
   if(i==4) print(list(Shapiro4,Lillie4))
   if(i==5) print(list(Shapiro5,Lillie5))
   if(i==6) print(list(Shapiro6,Lillie6))
   if(i==7) print(list(Shapiro7,Lillie7))
 }
 print(DW)
 print(BreuschPagan)
 sink()
}

